%define module_name HTTP-Tiny-Cache
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Util/Tempdir.pm) perl(HTTP/Tiny.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Pod/Coverage/TrustPod.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Cache HTTP::Tiny responses
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/HTTP-Tiny-Cache

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class is a subclass of the HTTP::Tiny manpage that cache responses.

Currently only GET requests are cached. Cache are keyed by SHA256-hex(URL).
Error responses are also cached. Currently no cache-related HTTP request or
response headers (e.g. `Cache-Control') are respected.

To determine cache max age, this module will consult environment variables (see
the section on "ENVIRONMENT"). If all environment variables are not set, will use the
default 86400 (1 day).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/H*

%changelog
