# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(HTTP/Tiny.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name HTTP-Tiny-FromHTTPRequest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Perform a request based on a plain HTTP request or HTTP::Request object
Group: Development/Perl
License: artistic_2
URL: http://github.com/reneeb/HTTP-Tiny-FromHTTPRequest

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RE/RENEEB/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use v5.10;
    use HTTP::Tiny::FromHTTPRequest;
    use HTTP::Request;
  
    my $http = HTTP::Tiny::FromHTTPRequest->new;
  
    my $plain_request = q~
    POST / HTTP/1.1
    Content-Length: 104
    User-Agent: HTTP-Tiny/0.025
    Content-Type: multipart/form-data; boundary=go7DX
    Connection: close
    Host: localhost:3000
    
    --go7DX
    Content-Disposition: form-data; name="file"; filename="test.txt"
    
    This is a test
    --go7DX--
    ~;
    
    my $response_from_object = $http->request( HTTP::Request->parse( $plain_request ) );
    if ( $response_from_object->{success} ) {
        say "Successful request from HTTP::Request object";
    }
    
    my $response_from_plain  = $http->request( $plain_request );
    if ( $response_from_plain->{success} ) {
        say "Successful request from plain HTTP request";
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md CONTRIBUTORS README LICENSE
%perl_vendor_privlib/H*

%changelog
