%define module_name HarfBuzz-Shaper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Tar.pm) perl(Capture/Tiny.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(charnames.pm) pkgconfig(harfbuzz)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.031
Release: alt1
Summary: Use HarfBuzz for text shaping
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JV/JV/%{module_name}-%{version}.tar.gz

%description
HarfBuzz::Shaper is a perl module that provides access to a small
subset of the native HarfBuzz library.

The subset is suitable for typesetting programs that need to deal with
complex languages like Devanagari.

This module is intended to be used with module the Text::Layout manpage. Feel
free to (ab)use it for other purposes.

Following the above example, the returned info is an array of hashes,
one element for each glyph to be typeset. The hash contains the
following items:

    ax:   horizontal advance
    ay:   vertical advance
    dx:   horizontal offset
    dy:   vertical offset
    g:    glyph index in font (CId)
    name: glyph name

Note that the number of glyphs does not necessarily match the number
of input characters!

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes INSTALL.md
%perl_vendor_archlib/H*
%perl_vendor_autolib/*

%changelog
