# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.2
%define module_name HookPrePostCall
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2
Release: alt1
Summary: Add actions before and after a routine (alpha 1.2)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PV/PVERD/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
`new()' creates a new object of the Hook::PrePostCall
class. Arguments of the new method are:

1. the name of the primary routine you want to "overload",

2. an anonymous routine to call before the primary routine,

3. an anonumous routine to call after the primary routine.

If the name of the primary subroutine has not an explicit package
prefix, it is assumed to be the name of a subroutine in the current
package of the caller of the new() method.

The pre routine acts as a filter of the primary routine arguments.
The post routine acts as a filter of what the primary returns.

new() can be used as a class or an object method. When used as an
object method the derived definition is built from the initial
definition of the primary routine.

`derived()' Returns the overloaded routine.

`pre()' Returns or set the pre action part.

`post()' Returns or set the post action part.

`primary()' Returns the primary routine.

`restore()' Retore initial definition of the primary routine.



%prep
%setup -n PrePostCall-%module_version
# move modules to lib
mkdir lib
mv H*/ lib/
sed -i -e 's,^\(H.*/\),lib/\1,' MANIFEST
ln -s lib/* .

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/H*

%changelog
