# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(Env.pm) perl(Exporter.pm) perl(ExtUtils/CBuilder.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Unicode/MapUTF8.pm) perl(YAML/Tiny.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 I18N-Charset
%define upstream_version 1.419

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    IANA Character Set Registry names and Unicode::MapUTF8
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/authors/id/M/MT/MTHURN/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(IO/Capture/Stderr.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This distribution contains a module I18N::Charset which maps Character
Set names to the names officially registered with IANA.  For example,
'Shift_JIS' is the official name of what is often referred to in HTML
headers as 'x-sjis'.

It also maps character set names to Unicode::Map, Unicode::Map8, and
Unicode::MapUTF8 conversion scheme names (if those modules are
installed).  For example, the Unicode::Map8 scheme name for
'windows-1251' is 'cp1251'.

It also maps character set names to their preferred MIME names.  For
example, the preferred MIME name for 'ISO_646.irv:1991' is 'US-ASCII'.

It also maps character set names to conversion scheme names as defined
by the iconv library.  For example, the iconv conversion scheme name
for 'Shift_JIS' is 'MS_KANJI'.

It also maps character set names to encoding names as defined
by the Encode module.  For example, the Encode encoding name
for 'Shift_JIS' is 'shiftjis'.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%{__make} test

%install
%makeinstall_std

%files
%doc Changes META.yml  README
%{perl_vendor_privlib}/I18N

%changelog
