%define module_name Image-GIF-Encoder-PP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Pure perl GIF encoding
Group: Development/Perl
License: perl
URL: https://github.com/G4Vi/gifenc-pl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GA/GAHAYES/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
use Image::GIF::Encoder::PP;
    my $palette = pack('CCCCCC', 0xFF, 0xFF, 0xFF, 0xDA, 0x09, 0xFF);               # Pack the RGB color pallete
    my $gif = Image::GIF::Encoder::PP->new('out.gif', 200, 200, $palette, 1, 0, 0); # create a 200x200 infinitely looping 1 bit color palette transparent gif
    $gif->{'frame'} = pack('x10000');                                               # set the pixels of the frame to palette index 0 (transparent in this case)
    Image::GIF::Encoder::PP::scale($frame, 100, 100, 2, \$destframe);               # scale a 100x100 frame by 2 and store in $destframe
    $gif->add_frame(5);                                                             # add a frame with a 5 ms delay
    undef $gif;                                                                     # finish writing to gif

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/I*

%changelog
