# BEGIN SourceDeps(oneline):
BuildRequires: perl(FindBin.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name In-Korean-Numbers-SinoKorean
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Convert integers to Sino-Korean text (in Hangul) and vice versa.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BR/BRYAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use In::Korean::Numbers;

    # Object-oriented API
    my $sk     = In::Korean::Numbers::SinoKorean->new();
    my $hangul = $sk->getHangul( 42 ); # .'E.'d.'E
    my $int    = $sk->getInt( '.ON.'E.'d.''' ); # 123
    
    # Procedural API
    $hangul = In::Korean::Numbers::SinoKorean::getHangul( 42 ); # .'E.'d.'E
    $int = In::Korean::Numbers::SinoKorean::getInt( '.ON.'E.'d.''' ); # 123
    

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/I*

%changelog
