%define module_version 1.0.0
%define module_name Inferno-RegMgr
# BEGIN SourceDeps(oneline):
BuildRequires: perl(EV.pm) perl(Export/Attrs.pm) perl(IO/Stream.pm) perl(Module/Build/Tiny.pm) perl(Scalar/Util.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.0
Release: alt1
Summary: Keep connection to OS Inferno's registry(4) and it tasks
Group: Development/Perl
License: mit
URL: https://github.com/powerman/perl-Inferno-RegMgr

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PO/POWERMAN/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
Using OS Inferno registry(4) is simple, but in case connection to registry
become broken (because of network issues or even registry restart) you
have to manually reconnect to registry and restore state (register your
services once again, find out changes in services you're using now, etc.).
Inferno::RegMgr will do this work for you automatically.

Inferno::RegMgr has plugin-based architecture. There two plugin types:
connection (which handle I/O to registry server) and task (like
registering your service or searching for services).

 Connection plugins:
    Inferno::RegMgr::TCP
 Task plugins:
    Inferno::RegMgr::Service
    Inferno::RegMgr::Lookup
    Inferno::RegMgr::Monitor

When you creating new Inferno::RegMgr object, you should provide
connection plugin, which will be used to access registry. Next you can
attach/detach to this Inferno::RegMgr object any amount of any task
plugins. Inferno::RegMgr will guarantee all these tasks will work when
connection to registry is available, and task's state will be
automatically restored after reconnecting to registry server.

This is EV-based module, so you have to run EV::loop in your code to use this
module.



%prep
%setup -q -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/I*

%changelog
