%define module_name Java-Maven-Artifact-Version
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta/Validator.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000001
Release: alt1
Summary: a perl module for comparing Artifact versions exactly like Maven does.
Group: Development/Perl
License: artistic_2
URL: https://github.com/apendragon/Java-Maven-Artifact-Version/wiki

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PA/PANDRAGON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Apache Maven  has a peculiar way to compare Artifact versions.
The aim of this module is to exactly reproduce this way in hope that it could be usefull to someone that wants to write utils like SCM hooks. It may quickly ensure an Artifact version respect a grow order without to have to install Java and Maven on the system in charge of this checking.

The official Apache document that describes it is here http://docs.codehaus.org/display/MAVEN/Versioning.
But don't blindly believe everything. Take the red pill, and I show you how deep the rabbit-hole goes.
Because there is a gap between the truth coded in `org.apache.maven.artifact.versioning.ComparableVersion.java' that can be found here and that Maven official document.

Lucky for you this module cares about the real comparison differences hard coded in `ComparableVersion' and reproduces it.

see the FAQ entry elsewhere in this document for details.
%prep
%setup -q -n %{module_name}-%{version}
rm -f t/[0-9][-_]meta.t t/[0-9][0-9][-_]meta.t t/[0-9]meta.t t/[0-9][0-9]meta.t t/meta.t


%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/J*

%changelog
