%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Lingua/Alphabet/Phonetic.pm) perl(Lingua/Alphabet/Phonetic/NATO.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/NoBreakpoints.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Lingua-Alphabet-Phonetic-Password
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: enunciate a password as words
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JF/JFITZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is a dictionary for Lingua::Alphabet::Phonetic.  It allows for
enunciation of passwords, using the following rules:

=over 4

=item * lowercase letters

enunciated using the NATO alphabet per Lingua::Alphabet::Phonetic::NATO, but
the word will be lowercased.

=item * uppercase letters

enunciated using the NATO alphabet per Lingua::Alphabet::Phonetic::NATO, but
the word will be uppercased.

=item * numbers

enunciated as an initialcaps word for the english pronuciation of the number.

=item * special characters

enunciated as a mixedcaps word for the english punctuation of the character:

  @ At
  ? Question
  _ Underscore
  # Hash
  & Ampersand
  ! Exclamation
  - Dash
  * Asterisk
  + Plus
  = Equals
  " DoubleQuote
  %% Percent
  ' SingleQuote
  ( LeftParens
  ) RightParens
  , Comma
  . Period
  / ForeSlash
  \ BackSlash
  : Colon
  ; SemiColon
  < LessThan
  > GreaterThan
  [ LeftBracket
  ] RightBracket
  { LeftBrace
  } RightBrace
  ^ Caret
  ` Backtick
  | Pipe
  ~ Tilde

=back

A character which does not fall into any of these categories is dispatched
back to the base class for conversion.  In the case of
Lingua::Alphabet::Phonetic, this returns the character unchanged.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README
%perl_vendor_privlib/L*

%changelog
