%define module_name List-AssignRef
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(LV.pm) perl(List/MoreUtils.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: assign an arrayref to an array sensibly
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/List-AssignRef

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
OK, so you might ask yourself, why would you want to do this:

	my \@array = $arrayref;

When you can just do this:

	my @array = @{ $arrayref };

Well, in that simple case List::AssignRef is overkill.

However, what about cases when you have a function that returns a list of
arrayrefs, such as `part' from the List::MoreUtils manpage. For example:

	my ($staff, $managers) = part { $_->title =~ /Manager/ } @employees;

If you want `@staff' and `@managers' arrays (as against arrayrefs),
you need to dereference each separately. Something like:

	my @parted = part { $_->title =~ /Manager/ } @employees;
	my @staff    = @{$parted[0]};
	my @managers = @{$parted[1]};

List::AssignRef makes this slightly prettier:

	(deref my @staff, deref my @managers)
		= part { $_->title =~ /Manager/ } @employees;

List::AssignRef exports exactly one function...

=over

=item `deref ARRAY|HASH|SCALAR'

`deref' must be given a (non-reference) array, hash or scalar. It acts as
an lvalue, allowing a reference array, hash or scalar respectively to be
assigned to it.

=back

This module uses the Sub::Exporter manpage which means that you can rename the
exported function easily:

	use List::AssignRef deref => { -as => 'dereference' };


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes CREDITS COPYRIGHT LICENSE
%perl_vendor_privlib/L*

%changelog
