%define module_version 0.10
%define module_name Log-Declare
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Declare/Lexer.pm) perl(Devel/Declare/Lexer/Token/Raw.pm) perl(FindBin.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A high performance Perl logging module
Group: Development/Perl
License: perl
URL: https://github.com/companieshouse/Log-Declare

Source0: http://cpan.org.ua/authors/id/C/CH/CHGOVUK/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Log::Declare;
    use Log::Declare qw/ :nosyntax /; # disables syntactic sugar
    use Log::Declare qw/ :nowarn :noerror ... /; # disables specific sugar

    # with syntactic sugar
    debug "My debug message" [category];
    error "My error message: %%s", $error [category1, category2];

    # auto-dump variables with Data::Dumper
    debug "Using sprintf format: %%s", d:$error [category];

    # auto-ref variables with ref()
    debug "Using sprintf format: %%s", r:$error [category];

    # capture other loggers (loses Log::Declare performance)
    Log::Declare->capture('Test::Logger::log');
    Log::Declare->capture('Test::Logger::log' => sub {
        my ($logger, @args) = @_;
        # manipulate logger args here
        return @args;
    });


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod README LICENSE Changes
%perl_vendor_privlib/L*

%changelog
