%define module_name LyricFinder
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTML/Strip.pm) perl(HTTP/Request.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(URI/Escape.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.50
Release: alt1
Summary: Fetch song lyrics from several internet lyric sites.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TU/TURNERJW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
LyricFinder accepts an artist name and song title, searches supported 
lyrics sites for song lyrics, and, if found, returns them as a string.

This module is derived from the (older0 Lyrics::Fetcher collection of modules 
by (c) 2007-2020 David Precious, but currently (as of December, 2020) supports 
more lyric sites (4), bundles all the supported site modules together here 
(simply install this one module), has reworked the "Cache" module to cache 
lyrics files by artist and song title on disk in the user's desired location.  
LyricFinder is also truly object-oriented making interaction with the 
user-facing methods and data easier and more streamlined.

NOTE:  This module is used completely independent of any of those modules, 
but the code is derived from them, as allowed by and the license and credits 
are included here, as required by their open-source license.  It is capable 
of being used as a drop-in replacement, but some function names and a few 
other code changes will be needed.

We've also added methods to easily change the "user-agent" passed to the 
lyrics sites, as needed/desired by the user programatically.

We've also changed the default to search the supported sites randomly, instead 
of in the same fixed alphabetical order by module name ("load-balancing" the 
searches to all the sites).  This is helpful when using LyricFinder as a 
plugin for streaming media players, such as the author's very own "Fauxdacious 
Media Player" that frequently stream internet radio stations, which can 
impose a "hit" on the lyrics sites each time the song title changes.  This 
reduces the odds of a user's IP-address possibly being banned by a lyrics site 
for "too-frequent scraping / usage"!  NOTE:  If you want to prevent the usage 
of one or more of the specific sites, simply delete or rename that site's 
submodule file.  If you want to use one or more specific sites, or enforce 
a specific search order, you can call the fetch() method with a third 
argument consisting of the site module name, ie. "Musixm...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
