%define module_name Math-Business-BlackScholes-Binaries-Greeks
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Math/Business/BlackScholesMerton.pm) perl(Math/CDF.pm) perl(Math/Trig.pm) perl(Test/CheckDeps.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/NoWarnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Sensitivity of the price of binary options
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BINARY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Greeks modules calculate the sensitivity of the price of binary options to a
change in the underlying parameters of the financial asset.

First-order Greeks

=over 4 

=item * Math::Business::BlackScholes::Binaries::Greeks::Delta

=item * Math::Business::BlackScholes::Binaries::Greeks::Vega

=item * Math::Business::BlackScholes::Binaries::Greeks::Theta

=back

Second-order Greeks

=over 4 

=item * Math::Business::BlackScholes::Binaries::Greeks::Gamma

=item * Math::Business::BlackScholes::Binaries::Greeks::Vanna

=item * Math::Business::BlackScholes::Binaries::Greeks::Volga

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
