%define module_name Math-Complex_C
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt2
Summary: perl interface to C's complex.h functions.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SISYPHUS/%{module_name}-%{version}.tar.gz

%description
This module wraps the 'double _Complex' type (as a Math::Complex_C
   object) and the 'long double _Complex' type (as a Math::Complex_C::Long
   object).


   use warnings;
   use strict;
   use Math::Complex_C qw(:all);
   my $c =    Math::Complex_C->new(12.5, 1125); # 'double _Complex' type
   my $root = Math::Complex_C->new();
   my $cl = Math::Complex_C::Long->new(5.9,1.1); # 'long double _Complex'
   my $rootl = Math::Complex_C::Long->new();
   sqrt_c($root, $c);
   sqrt_cl($rootl, $cl);
   print "Square root of $c is $root\n";
   print "Square root of $c1 is $rootl\n";

   On many perls, the values printed out by the above code will be
   identical - see the README for some elaboration.

   Note that Math::Complex_C and Math::Complex_C::Long objects use
   different functions (sqrt_c vs sqrt_cl, in the above example).

   See also the Math::Complex_C test suite for some (simplistic) examples
   of usage.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
