%define module_name Math-Complex_C-L
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Math/LongDouble.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt2
Summary: perl interface to C's long double complex operations.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SI/SISYPHUS/%{module_name}-%{version}.tar.gz

%description
use warnings;
   use strict;
   use Math::Complex_C::L qw(:all);
   # For brevity, use MCL which is an alias for Math::Complex_C::L::new
   my $c =    MCL(12.5, 1125); # assign as NV
   my $root = MCL();

   sqrt_cl($root, $c);
   print "Square root of $c is $root\n";

   See also the Math::Complex_C::L test suite for some (simplistic) examples
   of usage.

   This module is written largely for the use of perl builds whose nvtype is
   'long double'. Run "perl -V:nvtype" to see what your perl's NV type is. If
   your nvtype is 'double' consider using Math::Complex_C instead, and if
   your nvtype is '__float128' consider using Math::Complex_C::Q.
   Irrespective of the nvtype, you can still use this module - it's just
   that there are a number of functions returning 'long double' - which, for
   'double' and '__float128' builds do not utilise the full precision that the
   'long double' or '__float128' NV provides.
   OTOH, you *can* use Math::Complex_C - or, if your compiler supports it, use
   Math::Complex_C::Q (and make full use of the extra precision its operations
   provide) irrespective of your nvtype. See the "Which Math::Complex_C"
   section of the README that ships with this module's source for a more
   detailed explanation.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/M*
%perl_vendor_autolib/*

%changelog
