%define module_name Math-Formula
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/INI/Reader.pm) perl(Config/INI/Writer.pm) perl(Cpanel/JSON/XS.pm) perl(DateTime.pm) perl(DateTime/Duration.pm) perl(DateTime/Format/Duration/ISO8601.pm) perl(DateTime/TimeZone.pm) perl(DateTime/TimeZone/OffsetOnly.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(Log/Report.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Unicode/Collate.pm) perl(YAML/XS.pm) perl(boolean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Expressions on steriods
Group: Development/Perl
License: perl
URL: http://perl.overmeer.net/CPAN/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MARKOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
WARNING: This is not a programming language: it lacks control structures
like loops and blocks.  This can be used to get (very) flexible configuration
files for your program.

What makes Math::Formula special? Zillions of expression evaluators
have been written in the past.  The application where this module was
written for has special needs which were not served by them.
This expression evaluator can do things which are usually hidden behind
library calls.

For instance, where are many types which you can use in your configuration
lines to calculate directly (examples far down on this page)

  true and false               # real booleans
  "abc"  'abc'                 # the usual strings
  7  89k  5Mibi                # integers with multiplier support
  =~ "c$"                      # regular expressions
  like "*c"                    # pattern matching
  2023-02-18T01:28:12+0300     # date-times
  2023-02-18                   # dates
  01:18:12                     # times
  P2Y3DT2H                     # duration
  name                         # outcome of other expressions
  #unit.owner                  # fragments (context, namespaces)
  file.size                    # attributes
  (1 + 2) * 3                  # parenthesis

With this, your expressions can look like this:

  my_age   = (#system.now.date - 1966-05-04).years
  is_adult = my_age >= 18

Expressions can refer to values computed by other expressions.  The results are
cached within the context.  Also, external objects can maintain libraries of
formulas or produce compatible data.

Why do I need it? My application has many kinds of configurable
rules, often with dates and durations in it, to arrange processing.
Instead of fixed, processed values in my configuration, each line can
now be a smart expression.  Declarative programming.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md ChangeLog
%perl_vendor_privlib/M*

%changelog
