%define module_version 18
%define module_name Math-PlanePath-Toothpick
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Image/Base/Text.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Math/BaseCnv.pm) perl(Math/BigFloat.pm) perl(Math/BigInt.pm) perl(Math/BigRat.pm) perl(Math/Geometry/Planar.pm) perl(Math/Matrix.pm) perl(Math/NumSeq/OEIS/Catalogue/Plugin.pm) perl(Math/NumSeq/OEIS/File.pm) perl(Math/NumSeq/PlanePathTurn.pm) perl(Math/OEIS/Grep.pm) perl(Math/OEIS/Stripped.pm) perl(Math/PlanePath.pm) perl(Math/PlanePath/Base/Digits.pm) perl(Math/PlanePath/Base/Generic.pm) perl(Math/PlanePath/Base/NSEW.pm) perl(Math/PlanePath/SquareSpiral.pm) perl(Math/PlanePath/UlamWarburtonQuarter.pm) perl(Math/Polynomial.pm) perl(Math/Prime/XS.pm) perl(Memoize.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Test.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 18
Release: alt1
Summary: Toothpick and other cellular automaton mathematical paths through the 2-D plane.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/math-planepath/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This is the pattern of a cellular automaton growing by 3 cells at exposed
corners.  Points are numbered by a breadth-first tree traversal and
anti-clockwise at each node.  The default is four quadrants starting from
four initial cells N=0 to N=3,

    68  67                          66  65      4
    69  41  40  39  38  35  34  33  32  64      3
        42  20  19  37  36  18  17  31  ...     2
        43  21   8   7   6   5  16  30          1
        44  45   9   1   0   4  28  29     <- Y=0
        47  46  10   2   3  15  63  62         -1
        48  22  11  12  13  14  27  61         -2
        49  23  24  54  55  25  26  60         -3
    70  50  51  52  53  56  57  58  59  75     -4
    71  72                          73  74     -5
                         ^
    -5  -4  -3  -2  -1  X=0  1   2   3   4

The growth rule is a cell which is an exposed corner grows by the three
cells surrounding that corner.  So

    depth=0   depth=1         depth=2             depth=3

                                              d d d d d d d d
                                               \| |/   \| |/
                            c c     c c       d-c c-d d-c c-d
                             \|     |/           \|     |/
              b b b b       c-b b b b-c       d-c-b b b b-c-d
               \| |/           \| |/           /|  \| |/  |\
    a a       b-a a-b         b-a a-b         d d b-a a-b d d
         ->             ->               ->
    a a       b-a a-b         b-a a-b         d d b-a a-b d d
               /| |\           /| |\               /| |\  |/
              b b b b       c-b b b b-c       d c-b b b b-c-d
                             /|     |\           /|     |\
                            c c       c       d-c c-d d-c c-d
                                               /| |\   /| |\
                                              d d d d d d d d

"a" is the first cell in each quadrant and grows into the three "b" around
each.  Then for the "b" cells only the corner ones are exposed corners and
they grow to the "c" cells.  Those "c" cells are then all exposed corners
and give a set of 36 "d" cells.  Of those "d"s only the corners are exposed
corners for the next "e" level.

Grouping the three children of each corner shows the pattern


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/M*

%changelog
