%define module_name Math-SlideRule
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Data/Dumper/Concise.pm) perl(Math/Trig.pm) perl(Module/Build.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(namespace/clean.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.11
Release: alt1
Summary: slide rule support for Perl
Group: Development/Perl
License: bsd
URL: https://github.com/thrig/Math-SlideRule

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMATES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Slide rule support for Perl. The abbreviated slide rule names (short letter
names like C, D, etc.) are retained as attributes (though do not do much).
Rounding is performed on the input and output values.

Certain slide rule realities are skipped, such as left versus right sliding
based on whether the result stays within the same order of magnitude: `1.1 *
2.5' and `4.1 * 3.7' require opposite sliding directions to compute, and one
requires more management of the decimal.

the Math::SlideRule::PickettPocket manpage approximates a N 3P-ES pocket slide rule.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/M*

%changelog
