%define module_name Module-Install-GetProgramLocations
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Cwd.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/CaptureOutput.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Install.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Sort/Versions.pm) perl(Test/Compile.pm) perl(Test/More.pm) perl(UNIVERSAL/require.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3012
Release: alt1
Summary: perl module %module_name
Group: Development/Perl
License: gpl2
URL: https://github.com/coppit/module-install-getprogramlocations

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCOPPIT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
If you are installing a module that calls external programs, it's best to make
sure that those programs are installed and working correctly. This
Module::Install extension helps with that process. Given a specification of
the required programs, it attempts to find a working version on the system
based on the Perl configuration and the user's path.  The extension then
returns a hash mapping the program names to a hash containing the absolute
path to the program, the type, and the version number. (It's best to use the
absolute path in order to avoid security problems.)

The program specification allows the user to specify a default program, a
command-line name for the program to be set, and multiple types of satisfying
implementations of the program. For the types, the user can specify a function
to extract the version, and a version range to check the version.

The extension defaults to interactive mode, where it asks the user to specify
the paths to the programs. If the user specifies a relative path, the
extension converts this to an absolute path. The user can specify
"none", in which case the hash values will be undefined. Similarly, if the , or if the type or version cannot be determined, then the
hash values will be undefined.

The extension also supports a noninteractive mode, where the programs are
provided on the command line. For example, "perl Makefile.PL
PROGRAM=<program>" is used on the command line to indicate the desired
program. The path is converted to an absolute path.  "<program>" can be empty
to indicate that it is not available.

This extension will perform validation on the program, whether or not it was
specified interactively. It makes sure that the program can be run, and will
optionally check the version for correctness if the user provides that
information. If the program can't be run or is the wrong version, an error
message is displayed. In interactive mode, the user is prompted again.  If the
user enters the same information twice, then the information is used
regardless of any problems. In noninteractive mode, the program is used
anyway.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE CHANGES TODO
%perl_vendor_privlib/M*

%changelog
