%define module_name Mojolicious-Plugin-ReverseProxy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Uploader.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojolicious.pm) perl(Pod/Markdown/Github.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.706
Release: alt1
Summary: ReverseProxy plugin for the Mojolicious Perl framework
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OE/OETIKER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Mojolicious::Plugin::ReverseProxy module implements a proxy helper the controller.
By default it forwards all the headers verbatime except Host, Origin and Referer which
get re-written. 

The plugin takes the following options:

=over

=item helper_name

The name of the helper to register. The default name is `reverse_proxy_to'.

  helper_name => 'cookie_proxy'

=item req_processor

Can be pointed to an anonymous subroutine which is called prior to handing controll over to
the user agent.

In the example we remove the cookie header from the request and populate the
cookies from our private cookie store in the session. The effect of this is that the
user can not alter the cookies.

 req_processor => sub {
    my $ctrl= shift;
    my $req = shift;
    my $opt = shift;
    # get cookies from session
    $req->headers->remove('cookie');
    my $cookies = $ctrl->session->{cookies};
    $req->cookies(map { { name => $_, value  => $cookies->{$_} } } keys %%$cookies);
 },

=item res_processor

Can be pointed to an anonymous subroutine which is called prior to rendering the response.

In the example we use this to capture all set-cookie instructions and store them in the session.

 res_processor => sub {
    my $ctrl = shift;
    my $res = shift;
    my $opt = shift;
    
    # for fun, remove all  the cookies
    my $cookies = $res->cookies;
    my $session = $ctrl->session;
    for my $cookie (@{$res->cookies}){
        $session->{cookies}{$cookie->name} = $cookie->value;
    }
    # as the session will get applied later on
    $res->headers->remove('set-cookie');
 }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_privlib/M*

%changelog
