%define module_name Mojolicious-Plugin-SizeLimit
# BEGIN SourceDeps(oneline):
BuildRequires: /proc /usr/bin/perldoc perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(IO/Socket/INET.pm) perl(Linux/Smaps.pm) perl(Mojolicious.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Terminate workers that grow too large
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRAF/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Mojolicious::Plugin::SizeLimit manpage is a the Mojolicious manpage plugin that allows
to terminate the hypnotoad manpage worker processes if they grow too large. The
decision to end a process can be based on its overall size, by setting
a minimum limit on shared memory, or a maximum on unshared memory.

Actually, there are two big reasons your the hypnotoad manpage workers will grow.
First, your code could have a bug that causes the process to increase in
size very quickly. Second, you could just be doing operations that
require a lot of memory for each request. Since you can't rely that
Perl gives memory back to the system after using it, the process size
can grow quite large.

This module will not really help you with the first problem. For that
you should probably look into "BSD::Resource" or some other means of
setting a limit on the data size of your program. BSD-ish systems have
"setrlimit()", which will kill your memory gobbling processes. However,
it is a little violent, terminating your process in mid-request.

This module attempts to solve the second situation, where your process
slowly grows over time. It checks memory usage after every N requests,
and if it exceeds a threshold, calls the stop_gracefully entry in the Mojo::IOLoop manpage,
what as a result makes the worker stop accepting new connections and
terminate as soon as all its pending requests have been processed and
served.

By using this module, you should be able to set the configuration
directive the accepts entry in the Mojo::Server::Hypnotoad manpage to 0 (= unlimited).
This has the great advantage, that worker processes are not sig-killed
by the manager process at end-of-life if they do not finish within
the graceful_timeout entry in the Mojo::Server::Hypnotoad manpage.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/M*

%changelog
