# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooseX-MakeImmutable
%define upstream_version 0.02

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_12

Summary:    A convenient way to make many Moosen immutable (or mutable) in one shot
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MooseX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp/Clan.pm)
BuildRequires: perl(Class/Inspector.pm)
BuildRequires: perl(Devel/InnerPackage.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(Module/Pluggable.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Most.pm)
BuildArch: noarch
Source44: import.info

%description
MooseX::MakeImmutable is a tool for loading every Moose::Object within a
hierarchy and making each immutable/mutable. It uses the Module::Pluggable
manpage for searching and will load both inner and .pm packages.

In a nutshell, if you add a Moose-based package to your object hierarchy,
then MooseX::MakeImmutable, given a proper manifest, will pick it up and
mark it im/mutable (without you having to manually write-out the new
package).

NOTE: The name "MakeImmutable" is a bit of a misnomer, since this package
can both make_immutable AND make_mutable. However, 90% of the time, you'll
probably be using ->make_immutable

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes META.yml README
%perl_vendor_privlib/*




%changelog
