# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBIx/Class.pm) perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Hash/Merge.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/MarkAsMethods.pm) perl(MooseX/NonMoose.pm) perl(MooseX/Storage.pm) perl(MooseX/Storage/Basic.pm) perl(SQL/Translator.pm) perl(Scalar/Util.pm) perl(Test/DBIC.pm) perl(Test/Memory/Cycle.pm) perl(Test/More.pm) perl(base.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name MooseX-Storage-DBIC
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1.1
Summary: Additional MooseX::Storage functionality for DBIx::Class rows and data structures.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RE/REVMISCHA/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
package My::Schema::Result::Chair;

 # moose attribute we would like to serialize
 has 'legs' => ( is => 'rw', isa => 'Int', default => 4 );

 # column to serialize
 __PACKAGE__->add_columns(
   "id" => { data_type => "integer" },
 );

 # relationship to serialize
 __PACKAGE__->belongs_to("table" => "My::Schema::Result::Table", { chair_id => "id" });

 # field+method to serialize
 sub is_broken { return $self->{is_broken} }

 # declare fields to serialize
 with 'MooseX::Storage::DBIC';
 sub schema { return $myschema }
 __PACKAGE__->serializable(qw/ id legs table is_broken /);

 # convert an instance into a hashref
 my $row = $myschema->resultset('Chair')->first;
 my $serialized = $row->pack;

 # convert hashref back into instance
 my $orig_row = My::Schema::Result::Chair->unpack($serialized);


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/M*

%changelog
