# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    MooseX-Types-Email
%define upstream_version 0.008

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_3

Summary:    Email address validation type constraint for Moose
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/MooseX/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Email/Abstract.pm)
BuildRequires: perl(Email/Valid.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Module/Metadata.pm)
BuildRequires: perl(MooseX/Types.pm)
BuildRequires: perl(MooseX/Types/Moose.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(if.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Moose type constraints which uses the Email::Valid manpage and the
Email::Valid manpage to check for valid email addresses and messages.

Note that 'EmailMessage' must be an object that can be passed to the
Email::Valid manpage. Currently, constraining strings is not supported due
to the leniency of Email::Abstract.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENCE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
