%define module_name Net-EPP-Server
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/OpenSSL/Random.pm) perl(Cwd.pm) perl(DateTime.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(IO/Socket/SSL.pm) perl(List/Util.pm) perl(Mozilla/CA.pm) perl(Net/EPP.pm) perl(Net/EPP/Frame.pm) perl(Net/EPP/Protocol.pm) perl(Net/EPP/ResponseCodes.pm) perl(Net/Server/PreFork.pm) perl(No/Worries/DN.pm) perl(Socket.pm) perl(Socket6.pm) perl(Sys/Hostname.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(XML/LibXML.pm) perl(base.pm) perl(bytes.pm) perl(feature.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A simple EPP server implementation.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GB/GBROWN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Net::EPP::Server;
    use Net::EPP::ResponseCodes;

    #
    # these are the objects we want to support
    #
    my @OBJECTS = qw(domain host contact);

    #
    # these are the extensions we want to support
    #
    my @EXTENSIONS = qw(secDNS rgp loginSec allocationToken launch);

    #
    # You can pass any arguments supported by Net::Server::Proto::SSL, but
    # by default the server will listen on localhost port 7000 using a
    # self-signed certificate.
    #
    Net::EPP::Server->new->run(

        #
        # this defines callbacks that will be invoked when an EPP frame is
        # received
        #
        handlers => {
            hello   => \&hello_handler,
            login   => \&login_handler,
            check   => \&check_handler,
            info    => \&info_handler,
            create  => \&create_handler,

            # add more here
        }
    );

    #
    # The <hello> handler is special and just needs
    # to return a hashref containing server metadata.
    #
    sub hello_handler {
        return {
            # this is the server ID and is optional, if not provided the system
            # hostname will be used
            svID => 'epp.example.com',

            # this is optional
            lang => [ qw(en fr de) ],

            # these are arrayrefs of namespace URIs
            objects => [
                map { Net::EPP::Frame::ObjectSpec->xmlns($_) } @OBJECTS
            ],

            extensions => [
                map { Net::EPP::Frame::ObjectSpec->xmlns($_) } @EXTENSIONS
            ],
        };
    }

    #
    # All other handlers work the same. They are passed a hash of arguments and
    # can return a simple result code, a result code and message, a
    # XML::LibXML::Document object, or a result code and an array of
    # XML::LibXML::Element objects.
    #
    sub login_handler {
        my %%args = @_;

        my $frame = $args{'frame'};

        my $clid = $frame->getElementsByTagName('clid')->item(0)->textContent;
        my $pw = $frame->getE...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE README examples
%perl_vendor_privlib/N*

%changelog
