%def_without test
%define module_name Net-Google-Drive
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(HTTP/Request.pm) perl(JSON/XS.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Net/Google/OAuth.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: simple Google drive API module
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VR/VRAG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module use to upload, download, share file on Google drive
    use Net::Google::Drive;

    #Create disk object. You need send in param 'access_token', 'refresh_token', 'client_id' and 'client_secret'. 
    #Values of 'client_id' and 'client_secret' uses to create Net::Google::OAuth object so that update value of 'access_token'.
    my $disk = Net::Google::Drive->new(
                                        -client_id          => $client_id,
                                        -client_secret      => $client_secret,
                                        -access_token       => $access_token,
                                        -refresh_token      => $refresh_token,
                                        );

    # Search file by name
    my $file_name = 'upload.doc';
    my $files = $drive->searchFileByName( -filename => $file_name ) or croak "File '$file_name' not found";
    my $file_id = $files->[0]->{id};
    print "File id: $file_id\n";

    #Download file
    my $dest_file = '/home/upload.doc';
    $disk->downloadFile(
                            -file_id        => $file_id,
                            -dest_file      => $dest_file,
                            );

    #Upload file
    my $source_file = '/home/upload.doc';
    my $res = $disk->uploadFile( -source_file   => $source_file );
    print "File: $source_file uploaded. File id: $res->{id}\n";

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/N*

%changelog
