# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Net-MAC-Vendor
%define upstream_version 1.268

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    Look up the vendor for a MAC
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Net/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Compress/Bzip2.pm)
BuildRequires: perl(Compress/Zlib.pm)
BuildRequires: perl(Cwd.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(IO/Socket/SSL.pm)
BuildRequires: perl(Mojo/URL.pm)
BuildRequires: perl(Mojo/UserAgent.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Text/ParseWords.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
The Institute of Electrical and Electronics Engineers (IEEE) assigns an
Organizational Unique Identifier (OUI) to manufacturers of network
interfaces.  Each interface has a Media Access Control (MAC) address of six
bytes. The first three bytes are the OUI.

This module allows you to take a MAC address and turn it into the OUI and
vendor information.  You can, for instance, scan a network, collect MAC
addresses, and turn those addresses into vendors.  With vendor information,
you can often guess at what what you are looking at (e.g. an Apple product).

You can use this as a module as its individual functions, or call it as a
script with a list of MAC addresses as arguments. The module can figure it
out.  

This module tries to persistently cache with DBM::Deep the OUI information so
it can avoid using the network. If it cannot load DBM::Deep, it uses a normal
hash (which is lost when the process finishes). You can preload this cache
with the load_cache() function. So far, the module looks in the current
working directory for a file named mac_oui.db to find the cache. I need to
come up with a way to let the user set that location.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

%check
# Skip tests due to no networking on BS.
true || make test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENSE META.json META.yml  README examples
%{perl_vendor_privlib}/*

%changelog
