# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Net/CIDR/Lite.pm) perl(Socket.pm) perl(Socket6.pm) perl(Storable.pm) perl(Test/More.pm) perl(diagnostics.pm) perl(version.pm)
# END SourceDeps(oneline)
%define module_name Net-Patricia
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.23
Release: alt1
Summary: Patricia Trie for fast IP address lookups
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRUBER/%{module_name}-%{version}.tar.gz

%description
This module uses a Patricia Trie data structure to quickly
perform IP address prefix matching for applications such as IP subnet,
network or routing table lookups.  The data structure is based on a
radix tree using a radix of two, so sometimes you see patricia
implementations called "radix" as well.  The term "Trie" is derived
from the word "retrieval" but is pronounced like "try".  Patricia
stands for "Practical Algorithm to Retrieve Information Coded as
Alphanumeric", and was first suggested for routing table lookups by Van
Jacobsen.  Patricia Trie performance characteristics are well-known as
it has been employed for routing table lookups within the BSD kernel
since the 4.3 Reno release.

The BSD radix code is thoroughly described in "TCP/IP Illustrated,
Volume 2" by Wright and Stevens and in the paper ``A Tree-Based Packet
Routing Table for Berkeley Unix'' by Keith Sklower.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes COPYING
%perl_vendor_archlib/N*
%perl_vendor_autolib/*

%changelog
