%define module_name Net-SNMP-QueryEngine-AnyEvent
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/Handle.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/MessagePack.pm) perl(Data/MessagePack/Stream.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: multiplexing SNMP query engine client using AnyEvent
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRUBER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an AnyEvent-flavored Perl client for snmp-query-engine,
a multiplexing SNMP query engine.

    use Net::SNMP::QueryEngine::AnyEvent;

    my $sqe = Net::SNMP::QueryEngine::AnyEvent->new;

    $sqe->setopt("127.0.0.1", 161, { community => "meow" }, sub {});

    $sqe->gettable("127.0.0.1", 161, "1.3.6.1.2.1.1", sub {
      my ($h, $ok, $r) = @_;
      for my $t (@$r) {
        print "$t->[0] => $t->[1]\n";
      }
    });

    $sqe->get("127.0.0.1", 161,
      ["1.3.6.1.2.1.1.5.0", "1.3.6.1.2.1.25.1.1.0"],
      sub {
        my ($h, $ok, $r) = @_;
        print "Hostname: $r->[0][1]\n";
        print "Uptime  : $r->[1][1]\n";
    });

    $sqe->wait;


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_privlib/N*

%changelog
