%define module_name Net-SPID
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Crypt/OpenSSL/Random.pm) perl(Crypt/OpenSSL/X509.pm) perl(DateTime.pm) perl(DateTime/Format/XSD.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Spec.pm) perl(IO/Compress/RawDeflate.pm) perl(IO/Handle.pm) perl(IO/Uncompress/RawInflate.pm) perl(IPC/Open3.pm) perl(MIME/Base64.pm) perl(Mojo/XMLSig.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(URI.pm) perl(URI/Escape.pm) perl(URI/QueryParam.pm) perl(XML/Writer.pm) perl(XML/XPath.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.15
Release: alt1
Summary: SPID implementation for Perl
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Net::SPID;
    
    my $spid = Net::SPID->new(
        sp_entityid     => 'https://www.prova.it/',
        sp_key_file     => 'sp.key',
        sp_cert_file    => 'sp.pem',
    );
    
    # load Identity Providers
    $spid->load_idp_metadata('idp_metadata/');
    # or:
    $spid->load_idp_from_xml_file('idp_metadata/prova.xml');
    # or:
    $spid->load_idp_from_xml($metadata_xml);
    
    # get an IdP
    my $idp = $spid->get_idp('https://www.prova.it/');
    
    # generate an AuthnRequest
    my $authnreq = $idp->authnrequest(
        acs_index   => 0,   # index of AssertionConsumerService as per our SP metadata
        attr_index  => 1,   # index of AttributeConsumingService as per our SP metadata
        level       => 1,   # SPID level
    );
    
    # prepare a HTTP-Redirect binding
    my $url = $authnreq->redirect_url;

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README LICENSE AUTHORS CHANGES example
%perl_vendor_privlib/N*

%changelog
