%filter_from_requires /^perl.arybase.pm./d
%define module_name Net-SSH2-Cisco
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FileHandle.pm) perl(IO/Socket/INET.pm) perl(Net/SSH2.pm) perl(Socket.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt2
Summary: interact with a Cisco router via SSH
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VI/VINSWORLD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Net::SSH2::Cisco provides additional functionality to Net::SSH2
for dealing with Cisco routers in much the same way Net::Telnet::Cisco
enhances Net::Telnet.  In fact, this module borrows heavily from
both of those excellent modules.

This module is basically a cut/paste of:

=over 2

=item *

70%% Net::Telnet

=item *

20%% Net::Telnet::Cisco

=item *

5%% Net::SSH2(::Channel)

=item *

5%% original hack to make it all work together

=back

I tried many ways first:

=over 2

=item *

Create a child class of Net::SSH2 to no avail due to the C-type 
inside-out object it returns and my lack of experience.

=item *

Pass a Net::SSH2(::Channel) connetion to Net::Telnet(::Cisco) fhopen()
method, but it returned:

`Not a GLOB reference at [...]/perl/vendor/lib/Net/Telnet.pm line 679.'

=item *

Use Net::Telnet in `@ISA' with `AUTOLOAD' to leverage the accessors and 
code already written, but I'm not creating a Net::Telnet object and 
I couldn't get it to work.

=back

That left me the *(?only?)* option - to write this Franken-module "liberally
borrowing" from much smarter, more talented programmers than I.

Why Net::SSH2?  Because it's the only SSH module on CPAN that works for me.

=over 2

=item *

Net::SSH::Perl - too many dependencies making it too difficult to install;
especially on Windows.

=item *

Net::OpenSSH - does not work on Windows (partial success).

=item *

Control::CLI - does a great job of being a parent to Net::SSH2 and
Net::Telnet.  Unfortunately, not Net::Telnet::Cisco, so no Cisco-specific 
enhancements.

=item *

Net::Appliance::Session - seemed promising, but has more dependencies
than Net::SSH::Perl; no go.

=back

Net::SSH2 comes bundled in vendor\lib with Strawberry Perl distributions
and I've heard no complaints on Perl boards about use on *nix; so we're
ready to go!
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/N*

%changelog
