# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Socket.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Net-TL1UDP
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: Transaction Language 1 (TL-1) UDP Interface
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PC/PCARTER/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*Net::TL1UDP* provides subroutines that communicate directly to a TL-1 device using UDP.  Most TL-1 modules open a telnet session to a TL-1 gateway and use it to communicate with the device.  This module communicates directly with the device.

Net::TL1UDP has been used to communicate with the Alcatel 7300, the Alcatel 7330, and the Alcatel 7342.

=over 4

=item node_login ('DEVICE[:PORT]', 'USERNAME', 'PASSWORD')

Subroutine to log into the device.  The subroutine is using the following TL-1 command:  ACT-USER::(USERNAME):::(PASSWORD).  The default UDP port number is 13001 but can be changed by providing it, preceded by a colon, after the device's IP address or hostname.

If a "logged on" message is received, the subroutine returns a "1"; otherwise, it returns a "0".

=item tl1_cmd ('TL-1_COMMAND')

Sends a TL-1 command to the device.  The result will be an ASCII string containing the response to the command or a "0" (if the command times out or if the login subroutine was not executed).

=item tl1_cmdf ('TL-1_COMMAND')

Sends a TL-1 command to the device.  The result will be a formatted ASCII string containing the response to the command or a "0" (if the command times out or if the login subroutine was not executed).

If the command is successful (COMPLD), it strips off any response data that is NOT encapsulated in double quotation marks and removes the quotation marks as well (returning the "real" data from the response).  If the response did not contain anything encapsulated in double quotation marks, it will simply return "COMPLD".

If the command is unsuccessful (DENY), it will return the complete unformatted response.

=item debug_file ('path_to/debug_file')

Creates a debug file that contains the TL-1 commands and responses.

=item close_debug

Closes the debug file.  If this function is not called, the debug file will be closed (automatically) when the script finishes.

=item retrieve_sid

Returns the System ID (SID) of the device if it can be determined.

=item retrieve_ctag

Returns the current ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
