# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Apache2/Connection.pm) perl(Apache2/Const.pm) perl(Apache2/RequestIO.pm) perl(Apache2/RequestRec.pm) perl(Apache2/RequestUtil.pm) perl(Apache2/Response.pm) perl(Apache2/ServerRec.pm) perl(Apache2/URI.pm) perl(CPAN.pm) perl(Data/Dump.pm) perl(ExtUtils/CBuilder.pm) perl(HTTP/Headers.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Perl6/Say.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    OAuth-Lite
%define upstream_version 1.35

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

Summary:    PLAINTEXT signature method class;
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/OAuth/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Accessor.pm)
BuildRequires: perl(Class/Data/Accessor.pm)
BuildRequires: perl(Class/ErrorHandler.pm)
BuildRequires: perl(Compress/Zlib.pm)
BuildRequires: perl(Crypt/OpenSSL/RSA.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(inc/Module/Install.pm)
BuildRequires: perl(LWP.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(UNIVERSAL/require.pm)
BuildRequires: perl(URI.pm)
BuildArch:  noarch
Source44: import.info

%description
This framework allows you to make "OAuth Consumer Application" / "OAuth
Service Provider" easily.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
# we can live with pod errors
rm -f t/99_pod.t
rm -f t/99_pod_coverage.t
# test fail since perl-5.27 (RT#125359):
rm -f t/03_signature_method_rsa_sha1.t
make test

%install
%makeinstall_std

%files
%doc Changes META.yml  README examples
%{perl_vendor_privlib}/*


%changelog
