%filter_from_requires /^perl.arybase.pm./d
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Trig.pm) perl(Startup.pm) perl(Symbol.pm) perl(Unicode/Map.pm)
# END SourceDeps(oneline)
%define module_version 0.386
%define module_name OLE-Storage
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.386
Release: alt2
Summary: An Interface to Structured Storage Documents.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHWARTZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Documents done at Microsoft Windows Systems are tending to be stored in a.persistant data format, that MS calls "Structured Storage". This module gives
access to Structured Storage files. Alas, the current release allows more or
less read access, only. You can modify document contents (streams) with it,
but you cannot create or delete streams, nor rename them or change their
size. Also a file locking mechanism still is missing. I hope to offer write
support with next release.

=over 4

=item close

`1'||`O' == *$D* -> close ()

Close the document.

=item clsid

*$clsid* == *$D* -> clsid (*$pps*)

Returns the CLSID of the property *$pps* as CLSID Property.

=item color

`0'||`1' == *$D* -> color (*$pps*)

Returns the "color" of the property *$pps*.

=item date

*$Date* == *$D* -> name (*$pps*)

Returns a 0x40 Property (filetime) with the creation date of property
storage *$pps*. See OLE::Storage::Property for more information.

*Note*: As of now, only directory properties have filetime stamps.

=item directory

`1'||`O' == *$D* -> directory (*$pps*, *\%%Names* [,*method*])

Read the directory denoted by property handle *$pps*. Fills the hash array
*%%Names* with the property names as keys and property handles as values.
The property names are Unicode Properties. To use the directory hash easily
you optionally can apply a Property method. You will probably have to use
*"string"* or *"wstring"*. See OLE::Storage::Property for more information.

Note:
To get the root directory, call directory (0, *\%%Names*).

=item dirhandles

*@pps* == *$D* -> dirhandles (*$pps*)

Similar to directory (). Returns not the names, but only the property
handles of the directory denoted by property handle *$pps*.

Note:
Normally you will use directory () instead.
To get the root directory, call dirhandles(0)

=item Startup

*$Startup* == *$D* -> Startup ([*$NewStartup*])

Gets the current *$Startup* handler. If an optional argument *$NewStartup* 
is given, this new handler will be installed and returned.

=item is_directory

`1'||`O' == *$D* -> is_directory (*$pps*)

Returns 1 if the property handle *$pps* is refering to a directory, 
0 otherwise.

=item is_file

`1'||`O' == *$D* -> is_file (*$pps*)

Returns 1 if the property handle *$pps* is refering to a file,
0 otherwise.

=item is_root

`1'||`O' == *$D* -> is_root (*$pps*)

Returns 1 if the property handle *$pps* is refering to the document root, 
0 otherwise.

=item modify

`1'||`O' == *$D* -> modify (*$pps*, *\$buf*, *$offset*, *$size*)

Modifies the contents of the property file *$pps*. *$size* bytes of the
file *$pps* starting at offset *$offset* will be replaced by *$size*
bytes of the buf *$buf* starting at offset 0.

Note: This is still very restrictive, e.g. because the size of a file
cannot be changed. Also missing is a possibility to give an offset to *$buf*.

=item modify_trash

`1'||`O' == *$D* -> modify_trash (*$type*, *\$buf*, *$offset*, *$size*)

Modifies the contents of the trash section *$type*. *$size* bytes of the
trash section *$type* starting at offset *$offset* will be replaced by
*$size* bytes of the buf *$buf* starting at offset 0.

=item name

*$Name* == *$D* -> name (*$pps*)

Returns the name of the property *$pps* as Unicode Property.

=item NewVar

*$Var* == *$D* -> NewVar ()

Creates a new Variable handling object and returns it. (see also: open)

=item open

*$Doc*||`O' == Storage -> open (*$Startup*, *$Var*, *$file* [,*$mode*, *\$buf*])

Constructor. Open the document with document path *$file*. *$mode* can be
read or read/write. If you additionally specify modus buffer, the document 
data will be read from the buffer reference you specify with *$buf*.
Errors will be reported to Startup object *$Startup* (if present).

Open modes:

   Bit	= 0 		= 1
   0	Read Only	Read and Write
   4	File Mode	Buffer Mode

=item read

`1'||`O' == *$D* -> read (*$pps*, *\$buf*, [*$offset*, *$size*])

Read the file property *$pps* into buffer *$buf*. If there is an optional
*$offset* and *$size*, only this part of the file will be read.

=item read_trash

`1'||`O' == *$D* -> read_trash (*$type*, *\$buf* [,*$offset*, *$size*])

Read the trash section *$type* into buffer $buf. If there is an optional
*$offset* and *$size*, only this part of the trash section will be read.
Trash types can be 0, 1, 2, 4, 8 or a sum of this, like (1+2+8). 0 
is default and yields (1+2+4+8). You can find an explanation of these 
types in the lclean manpage.

Trash types:

   #  Type
   -------------------
   1  Big blocks
   2  Small blocks
   4  File end space
   8  System space

=item size

*$size*||`undef' == *$D* -> size (*$pps*)

Returns the size of the file property *$pps* in terms of bytes.

=item size_trash

*$size* == *$D* -> size_trash (*$type*)

Returns the byte size of the trash section *$type*.

=item Var

*$Var* == *$D* -> Var ([*$NewVar*])

Gets the current $Var handler. If an optional argument $NewVar is given,
this new handler will be installed and returned.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes COPYING README
%perl_vendor_privlib/O*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
