%define module_version 0.2.7
%define module_name OS-Package
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Extract.pm) perl(Config.pm) perl(Cwd.pm) perl(DateTime/Format/DateManip.pm) perl(Digest/MD5.pm) perl(Digest/SHA.pm) perl(English.pm) perl(Env.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(Getopt/Long.pm) perl(HTTP/Tiny.pm) perl(Hash/AsObject.pm) perl(IPC/Cmd.pm) perl(Log/Dispatch.pm) perl(Log/Log4perl.pm) perl(Module/Load.pm) perl(Moo.pm) perl(POSIX.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Usage.pm) perl(Pod/Wordlist.pm) perl(Role/Tiny.pm) perl(Template.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Time/Piece.pm)
BuildRequires: perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(YAML/Any.pm) perl(base.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.7
Release: alt1
Summary: OS Package Management System
Group: Development/Perl
License: bsd
URL: https://github.com/jfwilkus/OS-Package

Source0: http://cpan.org.ua/authors/id/J/JF/JFWILKUS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
From summary: %summary

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\!\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc README LICENSE Changes README.md
%perl_vendor_privlib/O*
%perl_vendor_privlib/auto/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
