Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-PPI-PowerToys
Version:        0.14
Release:        alt2_45
Summary:        Handy collection of small PPI-based utilities
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/PPI-PowerToys
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/PPI-PowerToys-%{version}.tar.gz
# Update Makefile.PL to not use Module::Install::DSL, CPAN RT#148301, proposed
# to the upstream.
Patch0:         PPI-PowerToys-0.14-Remove-using-of-MI-DSL.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/Scripts.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
# Run-time:
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(File/Find/Rule/Perl.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(PPI/Document.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(version.pm)
BuildRequires:  perl(warnings.pm)
# Tests only:
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(IPC/Run3.pm)
BuildRequires:  perl(PPI.pm)
BuildRequires:  perl(Probe/Perl.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Script.pm)

# Remove underspecified dependecies

Source44: import.info
%filter_from_requires /perl(\(File.Find.Rule\|File.Find.Rule.Perl\|File.Spec\|Getopt.Long\|IPC.Run3\|PPI.Document\|Probe.Perl\|Test.More\|Test.Script\|version\).pm)/d

%description
The PPI PowerToys are a small collection of utilities for working with Perl
files, modules and distributions.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}
Requires:       coreutils
Requires:       perl(blib.pm)
Requires:       perl(IPC/Run3.pm) >= 0.034
Requires:       perl(Probe/Perl.pm) >= 0.010
Requires:       perl(Test/More.pm) >= 0.470
Requires:       perl(Test/Script.pm) >= 1.030

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n PPI-PowerToys-%{version}
%patch0 -p1

# Remove bundled libraries
rm -r inc
perl -i -ne 'print $_ unless m{^inc/}' MANIFEST
# Remove tests which are always skipped
for T in t/97_meta.t t/98_pod.t t/99_pmv.t; do
    rm "$T"
    perl -i -ne 'print $_ unless m{^\Q'"$T"'\E}' MANIFEST
done
chmod +x t/*.t

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a Makefile.PL t %{buildroot}%{_libexecdir}/%{name}
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/bash
set -e
# Especially t/03_show.t expects installed files in a working directory. Copy
# or symlink them there.
DIR=$(mktemp -d)
cp -a %{_libexecdir}/%{name}/* "$DIR"
mkdir -p "$DIR"/lib/PPI "$DIR"/script "$DIR"/blib/lib/auto "$DIR"/blib/arch
ln -s %{perl_vendor_privlib}/PPI/PowerToys.pm "$DIR"/lib/PPI
ln -s %{_bindir}/ppi_copyright "$DIR"/script
ln -s %{_bindir}/ppi_version "$DIR"/script
pushd "$DIR"
prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
popd
rm -r "$DIR"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{_bindir}/ppi_*
%{perl_vendor_privlib}/PPI*

%files tests
%{_libexecdir}/%{name}

%changelog
