%define module_name Panda-next
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/ParseXS.pm) perl(NEXT.pm) perl(Panda/Install.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(threads.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.3
Release: alt4
Summary: Replacement for next::method, performing very fast, and super::method (next-by-mro), with Perl and ...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SY/SYBER/%{module_name}-%{version}.tar.gz

%description
Perl's `next::method' is a powerful tool which is required if you want to use C3 method resolution order.
However it is very slow (more than 10 times slower than `SUPER::subname'), so that if you actively use it,
and your code is fast, it can become slow quite soon.

`Panda::next' replaces `next::method', `maybe::next::method' and `next::can' with very fast versions which are nearly the same speed as
`SUPER::subname' calls and behave exactly as original methods. It replaces them globally even for modules that were loaded before `Panda::next'.

However using `next::' or `SUPER::' may lead to inconsistency in your code, because you could use `next::method' for a class which didn't say
`use mro 'c3'', or use `SUPER::' for a class which said `use mro 'c3''. Those methods don't care about your class's method resolution order, 
they always behave the same. This may lead to hard-to-diagnose bugs in code, for example image hierarchy

        A
       / \
      B   C
       \ /
        D

where all of classes have (except for A, it just says __PACKAGE__)
    
    sub func { say __PACKAGE__; shift->next::method }
    
and `D' didn't say `use mro 'c3''. For now it's okay, if you run this method, you will see `DBCA' as expected.
However if you remove methods from class `D' and class `B' you might expect to see <CA> however instead you will see just `A'.
That happens because there are 2 separate things: finding the entry method and finding the next method. Finding the first method is always
based on the MRO you selected (in our case it's DFS), while `next::method' or `SUPER::func' always uses certain MRO to find next method.

`Panda::next' introduces the new keyword <super::subname> which goes to the next method according to MRO of object's class
(or the class you initially called method on, in case of Class->method()). So if you replace shift->next::method with 
shift->super::func, you will see `DBA' and `A' in our example because MRO is DFS. If you say `use mro 'c3'' in class `D', you will see
`DBCA' and `CA' as exp...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_archlib/P*
%perl_vendor_autolib/*

%changelog
