%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(ExtUtils/MakeMaker.pm) perl(Parse/Lex.pm) perl(Parse/Yapp.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name Parse-Yapp-KeyValue
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: parser for simple key/value pairs
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DI/DIZ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
parse a string of simple key/value pairs and
store the results in a hash reference for easy
access.  Parse::KeyValue correctly handles
escaped quotes as well as escaped backslashes.

Parse::KeyValue will parse the following example
string:

     AL=53 AK=54 AB=55 TN="home sweet home" =$

into a hashref with the following contents:

     {
         ''   => '$',
         'AL' => '53',
         'TN' => 'home sweet home',
         'AK' => '54',
         'AB' => '55'
     }

multiple identical keys are treated as arrays.
the string

     A=1 A=2 A=3

will return a hash reference with the following
contents:

     { A => [ 1, 2, 3 ] }

tokens without an associated key name will be
treated as pairs with an empty string for the
key.  the string

     yeah alabama "crimson tide"

will return a hash reference with the following
contents:

     { '' => [ 'yeah', 'alabama', 'crimson tide' ] }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/P*

%changelog
