%define module_version 1.05
%define module_name Passwd-DB
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(DB_File.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.05
Release: alt1
Summary: Perl module for manipulating a password file stored in a BerkeleyDB hash
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EE/EESTABROO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Passwd::DB provides basic password routines.  It augments getpwnam and getpwuid functions with setpwinfo, modpwinfo, rmpwnam, mgetpwnam.  The routines can be used both in object context or straight.  When used in non-object context a call to init_db is required to initialize the global data base structure.  This does mean that you can have only one active database when used in non-object context.

new and init_db can be called with an optional second argument.  If it is set to 1 or 'create' the database will be created if it doesn't already exist.

getpwnam and getpwuid are the same as their respective core counterparts.

setpwinfo and modpwinfo are called with arrays containing (in order):
 name, crypted_password, uid, gid, gecos, home_directory, shell

rmpwnam is called with a scalar containing the login name.

mgetpwnam returns the same array that getpwnam returns without the 'unused' age or comment fields.

setpwinfo does a create/modify of the user.
modpwinfo only does a modify, it will return an error if the user doesn't exist.

rmpwnam removes the user with the given login.  It returns an error if the user doesn't exist.

Right now all functions croak when they can't open the database.  This will change if the majority of people don't like this behavior.

Error return values:
  < 0   system error occurred, error value should be in $!
    0   no error
    1   operation failed
    2   operation failed because user does not exist



%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/P*
%perl_vendor_privlib/auto/*

%changelog
