%define module_name Perl-Critic-Policy-Variables-ProhibitLoopOnHash
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(List/Util.pm) perl(Perl/Critic.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: Don't write loops on hashes, only on keys and values of hashes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/X/XS/XSAWYERX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
When "looping over hashes," we mean looping over hash keys or hash values. If
you forgot to call `keys' or `values' you will accidentally loop over both.

    foreach my $foo (%%hash) {...} # not ok
    action() for %%hash;           # not ok

An effort is made to detect expressions:

    action() for %%hash ? keys %%hash : ();                        # ok
    action() for %%{ keys $hash{'stuff'} ? $hash{'stuff'} : {} }; # ok

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/P*

%changelog
