# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(DBD/Pg.pm) perl(DBI.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 0.001
%define module_name Pg-Reindex
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: rebuild postgresql indexes concurrently without locking.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BI/BINARY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Postgresql indexes should be rebuilt on a regular basis for good performance.
This can be done with the `REINDEX' command, however, building indexes this way
requires an exclusive lock on the table. On the other hand, using
`CREATE INDEX CONCURRENTLY' avoids this lock.

`Pg::Reindex' builds new indexes using `CREATE INDEX CONCURRENTLY'. Then it
starts a transaction for each index in which it drops the old index and
renames the new one.

It handles normal indexes and `PRIMARY KEY', `FOREIGN KEY' and `UNIQUE'
constraints.
%prep
%setup -q -n perl-%{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.pod Changes
%perl_vendor_privlib/P*

%changelog
