%define module_name Piper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/AllUtils.pm) perl(List/UtilsBy.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Types/Common/Numeric.pm) perl(Types/Common/String.pm) perl(Types/LoadableClass.pm) perl(Types/Standard.pm) perl(namespace/clean.pm) perl(overload.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Flexible, iterable pipeline engine with automatic batching
Group: Development/Perl
License: apache
URL: http://metacpan.org/release/Piper/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/EH/EHLERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The software engineering concept known as a pipeline is a chain of processing segments, arranged such that the output of each segment is the input of the next.

the Piper manpage is a pipeline builder.  It composes arbitrary processing segments into a single pipeline instance with the following features:

=over

=item *

Pipeline instances are iterators, only processing data as needed.

=item *

Data is automatically processed in batches for each segment (with configurable batch sizes).

=item *

Built-in support exists for non-linear and/or recursive pipelines.

=item *

Processing segments are pluggable and reusable.

=back
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.mkdn
%perl_vendor_privlib/P*

%changelog
