%define module_name Pod-Markdown-Githubert
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(HTML/Entities.pm) perl(Pod/Markdown.pm) perl(Test2/V0.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: convert POD to Github-flavored Markdown
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MAUKE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Pod::Markdown::Githubert is a module for converting documents in POD format
(see the perlpod manpage) to Github-flavored Markdown. It is a subclass of
the Pod::Markdown manpage (which see for API documentation) that adds the following
Github-specific enhancements and fixes:

=over

=item *

Internal links (of the form `L</foo>') are converted to something that
hopefully matches how Github generates HTML ids for Markdown headings. In
short, internal links to a section of the current page should just work when
rendered on Github.

=item *

Github-specific Markdown code can be embedded literally using a
`=for github-markdown' paragraph or
`=begin github-markdown ... =end github-markdown' section.

In other words, if you want to render e.g. a badge, but only on Github, not all
Markdown renderers, put it in a `=for github-markdown' paragraph.

=item *

External links to module documentation normally point to
https://metacpan.org/. But that doesn't work for some of the manual pages
included with Perl because they are only generated when perl is built (such as
the perlapi manpage), so this module redirects all `perlXYZ' links to
https://perldoc.perl.org/, which has the full set.

=item *

Verbatim paragraphs are translated to fenced code blocks (surrounded by
````') with normalized indentation (meaning it doesn't matter whether the
paragraph is indented by 1 space, 4 spaces, or 23 spaces in the POD source; it
will generated the same Markdown).

=item *

Code blocks containing ````' are rendered correctly, as are code blocks in
nested structures (such as list items) even when a numbered list item starts
with a code block.

=item *

Syntax highlighting can be enabled by tagging each code block with its
language. As this module translates a POD document, it keeps a global "current
language" setting, which is applied to every verbatim paragraph. Initially the
"current language" is empty, which just produces ordinary ````' code blocks.

A `=for highlighter language=FOO' paragraph sets the "current language" to
*FOO*....

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/P*

%changelog
