Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Words from Pod::Wordlist::hanekomu were merged into Pod::Wordlist
# at Pod::Wordlist 1.06; if we have an older version of Pod::Wordlist,
# we'll need to use Pod::Wordlist::hanekomu itself instead.
%global old_pod_wordlist %(perl -MPod::Wordlist -e 'print (($Pod::Wordlist::VERSION < 1.06) ? 1 : 0);' 2>/dev/null || echo 0)

# noarch, but to avoid debug* files interfering with manifest test:
%global debug_package %{nil}

Name:		perl-Pod-Wordlist-hanekomu
Version:	1.132680
Release:	alt1_24
Summary:	Add words for spell checking POD
License:	GPL+ or Artistic
URL:		https://metacpan.org/release/Pod-Wordlist-hanekomu
Source0:	https://cpan.metacpan.org/modules/by-module/Pod/Pod-Wordlist-hanekomu-%{version}.tar.gz
Patch0:		Pod-Wordlist-hanekomu-1.132680-stopwords.patch
BuildArch:	noarch
# ===================================================================
# Module Build requirements
# ===================================================================
BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# ===================================================================
# Module requirements
# ===================================================================
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Test/Spelling.pm) aspell libaspell, aspell-en
BuildRequires:	perl(utf8.pm)
BuildRequires:	perl(warnings.pm)
# ===================================================================
# Test Suite requirements
# ===================================================================
BuildRequires:	perl(Carp.pm)
BuildRequires:	perl(File/Spec.pm)
BuildRequires:	perl(IO/Handle.pm)
BuildRequires:	perl(IPC/Open3.pm)
BuildRequires:	perl(Scalar/Util.pm)
BuildRequires:	perl(Test/More.pm)
# ===================================================================
# Author/Release test requirements
#
# Don't run these tests or include their requirements if we're
# bootstrapping, as many of these modules require each other for
# their author/release tests.
# ===================================================================
%if 0%{!?perl_bootstrap:1}
BuildRequires:	perl(English.pm)
BuildRequires:	perl(Pod/Coverage/TrustPod.pm)
BuildRequires:	perl(Pod/Wordlist.pm)
BuildRequires:	perl(Test/HasVersion.pm)
BuildRequires:	perl(Test/CheckChanges.pm)
BuildRequires:	perl(Test/CPAN/Meta.pm)
BuildRequires:	perl(Test/DistManifest.pm)
BuildRequires:	perl(Test/EOL.pm)
BuildRequires:	perl(Test/Kwalitee.pm)
BuildRequires:	perl(Test/MinimumVersion.pm)
BuildRequires:	perl(Test/NoTabs.pm)
BuildRequires:	perl(Test/Perl/Critic.pm)
BuildRequires:	perl(Test/Pod/Coverage.pm)
BuildRequires:	perl(Test/Pod.pm)
BuildRequires:	perl(Test/Portability/Files.pm)
BuildRequires:	perl(Test/Synopsis.pm)
BuildRequires:	perl(Test/Vars.pm)
%endif
# ===================================================================
# Runtime requirements
# ===================================================================
Requires:	aspell libaspell
Source44: import.info

%description
When loaded, this module automatically adds Test::Spelling stopwords for
POD spell checking, that is, words that should be ignored by the spell
check.

The stopword list includes some CPAN author names, technical terms (e.g.
JSON, URI) and other commonly-used words not included in the default
word list (e.g. mixin, munging).

%prep
%setup -q -n Pod-Wordlist-hanekomu-%{version}

# Need to use our own stopwords unless we have Pod::Wordlist ≥ 1.06
%if %{old_pod_wordlist}
%patch0
%endif

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -delete
# %{_fixperms} -c %{buildroot}

%check
make test %{!?perl_bootstrap:AUTHOR_TESTING=1 RELEASE_TESTING=1}

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/Pod/

%changelog
