%define module_version 1.04
%define module_name Prancer-Plugin-Database
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Mock.pm) perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Module/Load.pm) perl(Plack/Runner.pm) perl(Prancer.pm) perl(Prancer/Core.pm) perl(Prancer/Plugin.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Try/Tiny.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: threaded, single-process application server like, say, the Twiggy manpage, all users of
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PL/PLOCKABY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This plugin enables connections to a database and exports a keyword to access
those configured connections.

It's important to remember that when running your application in a single-
threaded, single-process application server like, say, the Twiggy manpage, all users of
your application will use the same database connection. If you are using
callbacks then this becomes very important and you will want to take care to
avoid crossing transactions or expecting a database connection or transaction
to be in the same state it was before a callback.

To use a database connector, add something like this to your configuration
file:

    database:
        connection-name:
            driver: Prancer::Plugin::Database::Driver::DriverName
            options:
                username: test
                password: test
                database: test
                hostname: localhost
                port: 5432
                autocommit: true
                charset: utf8
                connection_check_threshold: 10

The "connection-name" can be anything you want it to be. This will be used when
requesting a connection from the plugin to determine which connection to return.
If only one connection is configured it may be prudent to call it "default" as
that is the name that Prancer will look for if no connection name is given.
For example:

    use Prancer::Plugin::Database qw(database);

    Prancer::Plugin::Database->load();

    my $dbh = database;  # returns whatever connection is called "default"
    my $dbh = database("foo");  # returns the connection called "foo"
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE examples
%perl_vendor_privlib/P*

%changelog
