%define module_name Redis-JobQueue
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/UUID.pm) perl(Digest/SHA1.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(List/MoreUtils.pm) perl(Mouse.pm) perl(Params/Util.pm) perl(Redis.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/NoWarnings.pm) perl(Test/RedisServer.pm) perl(Test/TCP.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.19
Release: alt1
Summary: Redis::JobQueue simple job queue with Redis server capabilities.
Group: Development/Perl
License: perl
URL: https://github.com/TrackingSoft/Redis-JobQueue

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SG/SGLADKOV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The main features of the package are:

=over 3

=item *

Supports the automatic creation of job queues, job status monitoring,
updating the job data set, obtaining a consistent job from the queue,
removing jobs, and the classification of possible errors.

=item *

Contains various reusable components that can be used separately or together.

=item *

Provides an object oriented API.

=item *

Support of storing arbitrary job-related data structures.

=item *

Simple methods for organizing producer, worker, and consumer clients.

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
