# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(IO/File.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name RestrictionDigest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A simulation tool for reducing the genome with one DNA endonuclease or a pair DNA endonucleases!
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JI/JINPENG/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Next Generation Sequencing (NGS) is developing quickly and many cost-saving approaches are developed based on NGS.  As sequencing 
the whole genome is expensive and sometimes unnecessary, sequencing the representative part of the whole genome becomes practicable 
and attractive. The most famous two approaches are Genotyping By Sequencing (GBS) and Restrict site Associated DNA sequencing (RAD).
These two approaches can reduce the  ratio of sequenced part of the whole genome which will save a lot of money. Both of them 
utilize tpye II DNA endonuclease to digest the whole genome. In order to select the correct enzyme or enzyme-pair, we developed 
this perl module: RestrictionDigest.

RestrictionDigest is used for the simulation of single/double-enzyme GBS/RAD approach. The most important thing of representative sequencing 
is choosing the right enzymes to digest the whole genome. The appropriate enzymes should satisfy several criteria including: the 
recognition sites of these two enzymes are evenly dispersed on each single chromsome;  the recognition sites of these two enzymes 
are not or rarely located at the repetitive region of the genome; the fragments produced by two-enzyme digestion are neither too long 
nor too short, they should be in the suitable range which is most  effective for PCR amplification; the complexity reducing rate 
shoule be in the suitable range(1%%-10%%).  RestrictionDigest can produce several result files including the fragments seqence and their 
locations on the reference. The ratio of these fragments on the reference seqences are also produced. If User can provide the gff 
annotation file, RestrictionDigest can also provide the coverage ratio of these fragments on gene region, even CDS, INTRON, UTR region, 
and intergenic region.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/R*

%changelog
