%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(ExtUtils/MakeMaker.pm) perl(Log/Log4perl.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Rose-DBx-Object-InternalPager
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Throttle Rose DB Iterator Fetching
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Rose::DBx::Object::InternalPager' is a 3rd party module for `Rose::DB' iterators
to work around MySQL client's limited control over how many rows are
fetched from the database at a time. 

`Rose::DBx::Object::InternalPager' provides a hack to limit 
the number of fetched records and prevents programs from running out
of memory.
   
The pager creates an iterator object, similar to the Rose `Manager''s 
`get_xxx_iterator()', method. 
Except, behind the scenes, the pager makes sure to never fetch more
than a preset number of records from the database at a time. To
accomplish this, it uses LIMIT to limit the number of records
retrieved, and OFFSET to fetch the next batch.

This approach might lead to anomalies when the database gets modified while
the pager is at work, and this is the reason why this module has been 
released *outside* of the `Rose::DB' realm as a 3rd party module.

While normally, you would call

    my $itr = Namespace::Author::Manager->get_authors_iterator(...);

to get an iterator object which offers a `next()' method to move
from one database record to the next. With `Rose::DBx::Object::InternalPager', 
you call

    my $pager = Rose::DBx::Object::InternalPager->new(
        class_name     => "Namespace::Author", # Note: no 'Manager'
        manager_method => "get_authors",       # Note: no 'iterator'
        # ...
    );

which returns a pager object that can be used to iterate over
all database records found via

    while(my $author = $pager->next()) {
        # ...     
    }

Just as the manager's `get_xxx_iterator()' method offers ways
to modify the query with `query', `sort_by' and other parameters,
these parameters can be set with the pager by using the `manager_options'
parameter:

    my $pager = Rose::DBx::Object::InternalPager->new(
        class_name      => "Namespace::Author", # Note: no 'Manager'
        manager_method  => "get_authors",       # Note: no 'iterator'
        manager_options => { 
          query           => [ published => 'yes' ],
          require_objects => [ 'city_of_birth' ],
          sort_by         => 'last_name',
        },
    );

By default, the pager fetches 50 records at a time. This value can
be modified by setting the `per_page' parameter in the 
optional `pager_options' hash:

    my $pager = Rose::DBx::Object::InternalPager->new(
        # ...
        pager_options => {
          per_page => 100,
        },
    );

By default, the pager starts at page 1. This value can
be modified by setting the `start_page' parameter in the 
optional `pager_options' hash:

    my $pager = Rose::DBx::Object::InternalPager->new(
        # ...
        pager_options => {
          start_page => 17,
        },
    );


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/R*

%changelog
