%define module_name SQL-SimpleOps
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(Date/Calc.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(IO/File.pm) perl(JSON.pm) perl(Pod/Usage.pm) perl(Sys/Syslog.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2024.213.1
Release: alt1
Summary: SQL Simple Operations
Group: Development/Perl
License: gpl
URL: https://sourceforge.net/p/csi-sql-simpleops/wiki/Home/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CC/CCELSO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description


This module was created to execute basic SQL commands in a database engine,
where it proposes the most common and basic operations with low parameter complexity.

The module allow switch between database engine without recoding.
It makes the necessary adjusments in SQL statement according the database engine in use,
reducing the complexity in the applications's code,
where the current version has built-in support for the databases: *MySQL*, *MariaDB*, *Postgres* and *SQLite3*.

However, the module does not convert the fields format in the databases,
where each one has its restrictions and rules.
We understand that the table in use have same format and data type and supported by all engines.

By default, evey command invoked will be effectively executed in database,
however this process can be suppressed if requested and the SQL command can retrieve (if neeeded, see: `make_only' option).

All parameters set in the Constructor (method new) are defined as Global Parameters, and some options can be enable/disable by the Methods, for more information see the Global Options entry elsewhere in this document.

All executed commands can saved in flat files for Debugging and/or Control and/or Recovery purposes, for more infomration se the Global Options entry elsewhere in this document.

All implemented methods deliver standards return code, where can be:

=over

=item *

rc < 0,_Parameters and/or options have syntax errors;

=item *

rc = 0,_SQL command successful executed;

=item *

rc = 1,_SQL command execute with errors;

=item *

rc = 2,_SQL command successful executed without match.

=back

The message details and return code must be extracted by:

=over

=item *

For *Constructor (new) Method:* Use `SQL::SimpleOps::err' and `SQL::SimpleOps::errstr values'.

=item *

For *Other Methods:* Use `getRC' and `getMessage' modules (recommended).

=back

By default the module send the messages on `STDERR', unless that requested by the application (see `message_log' option in the Global Options entry elsewhere in th...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes AUTHORS LICENSE
%perl_vendor_privlib/S*

%changelog
